# 第三章 中国开源项目发展现状

## 3.1 GitHub中国项目活跃度及趋势

据全球GitHub事件日志、活跃仓库、活跃开发者五年趋势图显示，GitHub仓库与开发者活跃数量稳步上涨，事件日志总量在2021年突破了10亿条。通过统计全域GitHub 事件日志，可观测到近5年全球开源的总体活跃情况和活跃仓库数量都在明显上升。特别是COVID-19疫情暴发已来，尽管新冠疫情影响了人们的工作生活，但是没有阻止开源事业的发展。与此同时，中国开源发展也进入平稳增长期，随着2021年国家对开源的支持政策出台以及开放原子开源基金会的成立，促使各大企业相继拥抱开源、大力投入、并涌现出一批以开源为主的初创企业。可以预见，在不久的将来，中国开源的发展还将进入新的快速增长期。

![](https://img-blog.csdnimg.cn/165d9b594820479ca56365db9f3edb41.png)<br/>*图1 全球 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图*

![](https://img-blog.csdnimg.cn/999b036ec86f440baf242f1700ce5671.png)<br/>*图2 中国 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图*

为了更好地展现中国企业在全球范围内的开源贡献水平，本节通过对比美国与中国活跃度排名前十的开源贡献企业、美国与中国开源影响力排名前十的企业进行分析。

美国的大型互联网企业在开源活跃度与影响力方面持续领先，微软由于使用GitHub作为大部分团队的日常开发平台，故项目数量较大，总活跃度第一，Google次之，而在项目平均活跃度方面，Google依然是世界上平均活跃度最高的企业。在中国企业的开源活跃度排名中，阿里巴巴的项目数量和总活跃度均为榜首，但整体项目体量以及活跃度总量距离美国Google等大企业还有一定的差距。不过，中国的开源初创企业和项目则表现抢眼，根据项目平均活跃度可见如 PingCAP、百度、青云、悦数科技（vesoft）都脱颖而出。

| 排名 | 公司 | 活跃项目数 | 年度活跃度 | 项目平均活跃度 | 
| - | - | - | - | - | 
| 1	| Microsoft	| 2890 | 595611.4 | 206.09 |
| 2 | Google| 1513 | 383039.73 | 253.17 | 
| 3	| Amazon| 	2944	| 225541.08	| 76.61 | 
| 4| 	Meta	| 675	| 138395.95| 	205.03 | 
| 5	| HarshiCorp| 	461	| 86819.23| 	188.33 | 
| 6| 	IBM	| 1298| 	76207.36	| 58.71 | 
| 7	| VMWare| 	479	| 74610.17	| 155.76 | 
| 8	| Adobe| 	521	| 54302.56| 	104.23 | 
| 9	| Mozilla	| 493	| 45360.11| 	92.01 | 
| 10	| Oracle	| 307| 	44676.89| 	145.53 | 

*表1 美国企业活跃度 Top 10*

| 排名	| 公司	| 活跃项目数	| 年度活跃度	| 项目平均活跃度 | 
|------|------| ------------| ---------| -----------| 
| 1| 	Alibaba	| 884	| 77529.86| 	87.7| 
| 2	| Baidu| 	244| 	60428.08| 	247.66| 
| 3| 	Ant Group	| 348	| 53370.07| 	153.36| 
| 4| 	PingCAP| 	120	| 46335.04| 	386.13| 
| 5	| Tencent| 	295	| 25734.77	| 87.24| 
| 6	| Huawei| 	118	| 10095.76	| 85.56| 
| 7	| QingCloud	| 48| 	9396.54	| 195.76| 
| 8| 	Fit2Cloud	| 63| 	9002.51| 	142.9| 
| 9	| vesoft| 	41| 	7943.96	| 193.76| 
| 10| 	JD| 	51| 	6488.17	| 127.22| 

*表2 中国企业活跃Top 10*

从总体活跃度指标来看，虽然在开源项目的体量方面，中国较美国有一定落差，但在项目平均活跃度方面则水平相当，因此，中国需要继续大力孵化、培育优秀开源项目。

企业的开源影响力指标更关注开发者生态，对比美国与中国的企业在影响力指标可见，美国的开源项目数量更多，二者在项目平均影响力的表现则相当。在中国企业中，有赞的开源项目影响力最高，从一众企业中脱颖而出，这得益于其主要的开源项目vant良好的开发者生态。

| 排名	|  公司	|  活跃项目数 |  年度影响力 | 项目平均影响力| 
| -----|  -----|  -----| -----| -----| 
| 1	| Microsoft| 2890| 224114.4| 	77.55| 
| 2	| Google	| 1513	| 142342.51	| 94.08| 
| 3	| Amazon	| 2944	| 80701.99	| 27.41| 
| 4	| Meta| 	675| 	50879.46| 	75.38| 
| 5	| HarshiCorp| 	461	| 32073.12	| 69.57| 
| 6	| VMWare| 	479	| 25840.51	| 53.95| 
| 7	| IBM| 	1298	| 24501.97	| 18.88| 
| 8	| Adobe| 	521| 	19404.18| 	37.24| 
| 9	| Mozilla	| 493	| 16666.94	| 33.81| 
| 10| 	Oracle| 	307| 	12400.01	| 40.39| 

*表3 美国企业影响力Top 10*

|排名	|公司	|活跃项目数	|年度影响力	|项目平均影响力|
|-------|-----|-----|-----|-----|
|1|	Alibaba	|884	|28316.93	|32.03|
|2|	Baidu|	244|	20696.04|	84.82|
|3	|Ant Group|	348	|19787.86	|56.86|
|4	|PingCAP|	120	|11433.79	|95.28|
|5	|Tencent	|295	|9482.08	|32.14|
|6|	Fit2Cloud	|63|	3467.84	|55.05|
|7	|Huawei	|118	|3141.95|	26.63|
|8|	JD|	51	|2816.56|	55.23|
|9|	QingCloud	|48|	2593.78	|54.04|
|10	|Youzan	|20	|2009.5	|100.47|

*表4 中国企业影响力Top 10*

此外，从中国企业近5年的开源发展趋势，包括活跃度趋势与影响力趋势来看，阿里巴巴、百度、蚂蚁集团长期名列前茅。其中，阿里巴巴的开源活跃度与影响力长期排名榜首，百度近几年对开源的投入与贡献显著增加。值得一提的是初创企业PingCAP，其开源活跃度与影响力一直稳居第四的位置。

![](https://img-blog.csdnimg.cn/9d80d45f0dd8415b878400d3251cf9bd.png)<br/>*图3 中国企业活跃度Top 10 2017 – 2021*

![](https://img-blog.csdnimg.cn/d70c9ec6b4d640c9a1cfa8400e3c1793.png)<br/>*图4 中国企业影响力Top 10 2017-2021*

同样的，根据开源项目活跃度和影响力，相较GitHub中全球开源项目和中国开源项目的Top 20，可见从单个项目而言，中国主导的开源项目的活跃度和影响力距离全球顶级开源项目的活跃度与影响力还有一定差距，特别是在影响力方面，需要国内企业最大限度地融入全球开源生态中发展中国开源项目。

|排名	|项目|	活跃度|
|------|----|-----|
|1	|microsoft/vscode	|33070.68|
|2|	flutter/flutter	|29879.26|
|3	|MicrosoftDocs/azure-docs	|25973.92|
|4|	home-assistant/core	|25358.57|
|5|	NixOS/nixpkgs	|21359.84|
|6|	firstcontributions/first-contributions|	19243.76|
|7|	education/GitHubGraduation-2021|	19025.12|
|8|	kubernetes/Kubernetes	|16075.66|
|9|	pytorch/pytorch	|15508.83|
|10|	rms-support-letter/rms-support-letter.github.io	|14366.78|
|11	|dotnet/runtime	|14161.06|
|12	|tensorflow/tensorflow|	13646.4|
|13|	trustwallet/assets|	13626.68|
|14	|nadimkobeissi/appleprivacyletter	|13270.31|
|15	|rust-lang/rust	|12438.41|
|16	|DefinitelyTyped/DefinitelyTyped|	12331.6|
|17	|google/it-cert-automation-practice	|12267.27|
|18	|vercel/next.js|	11503.95|
|19	|elastic/kibana|	10873.39|
|20	|solana-labs/token-list|	10871.74|

*表5 GitHub全球项目活跃度Top 20*

|排名|	项目|	活跃度|
|------|----|-----|
|1	|PaddlePaddle/Paddle	|6910.25|
|2	|ant-design/ant-design	|6871.28|
|3	|pingcap/tidb	|4909.91|
|4	|apache/flink	|4040.65|
|5	|PaddlePaddle/PaddleOCR	|3730.26|
|6	|alibaba/nacos	|3553.02|
|7	|apache/echarts	|3434.79|
|8	|NervJS/taro	|3198.13|
|9	|ant-design/pro-components	|3170.71|
|10	|apache/shardingsphere|	2965.63|
|11	|apache/tvm	|2960.93|
|12	|ant-design/ant-design-pro|	2539.22|
|13	|apache/apisix	|2502.93|
|14	|PaddlePaddle/PaddleDetection|	2489.83|
|15	|goharbor/harbor|	2368.87|
|16	|apache/dolphinscheduler	|2336.55|
|17	|umijs/umi|	2334.09|
|18	|k3s-io/k3s	|2140.97|
|19	|apache/dubbo	|2115.15|
|20|	metersphere/metersphere	|2089.56|

*表6 GitHub 中国项目活跃度 Top 20*

|排名	|项目|	活跃度|
|-|-|-|
|1|	flutter/flutter	|18857.68|
|2|	microsoft/vscode|	17659.6|
|3|	MicrosoftDocs/azure-docs	|16710.7|
|4|	home-assistant/core|	15286.07|
|5|	NixOS/nixpkgs	|14894.64|
|6|	dotnet/runtime|	11091.54|
|7|	pytorch/pytorch|	10303.65|
|8|	elastic/kibana|	10114.1|
|9|	kubernetes/kubernetes	|9995.07|
|10|	tensorflow/tensorflow	|8299.86|
|11	|odoo/odoo	|8030.23|
|12	|rust-lang/rust	|7936.85|
|13	|nadimkobeissi/appleprivacyletter	|7827.54|
|14	|education/GitHubGraduation-2021	|6939.31|
|15	|grafana/grafana	|6731.79|
|16	|godotengine/godot|	6487.95|
|17	|firstcontributions/first-contributions|	6371.63|
|18	|google/it-cert-automation-practice	|6102.26|
|19	|vercel/next.js|	5901.83|
|20	|dotnet/aspnetcore|	5854.07|

*表7 GitHub全球项目影响力Top 20*

|排名|	项目	|活跃度|
|-|-|-|
|1|	PaddlePaddle/Paddle	|4212.15|
|2|	ant-design/ant-design	|3815.5|
|3|	pingcap/tidb	|2938.56|
|4|	apache/flink	|2248.57|
|5|	PaddlePaddle/PaddleOCR	|2058.76|
|6|	alibaba/nacos|	1997.18|
|7|	apache/echarts|	1966.18|
|8	|NervJS/taro	|1964.7|
|9	|apache/tvm	|1805.99|
|10	|ant-design/pro-components|	1721.37|
|11|	apache/shardingsphere	|1716.68|
|12	|goharbor/harbor|	1416.36|
|13	|metersphere/metersphere	|1377.46|
|14	|ant-design/ant-design-pro|	1376.3|
|15	|umijs/umi|	1279.98|
|16	|PaddlePaddle/PaddleDetection	|1265.74|
|17	|apache/dolphinscheduler|	1235.61|
|18	|apache/dubbo	|1217.44|
|19	|tikv/tikv|	1209.32|
|20|	apache/apisix|	1196.04|

*表8 GitHub中国项目影响力Top 20*

## 3.2 中国重点领域开源项目发展现状

在国家政策、资本力量、商业组织与科研机构等多方利好形势下，人工智能、大数据、云计算、工业互联网、区块链等技术快速发展，并被广泛应用。与此同时，各技术领域受开源文化影响，秉承开源、开放的态度建设多层次人才培养体系、构筑产业集群优势、加快推动应用发展、促进产业融合创新。如今，人工智能、大数据、云计算、工业互联网、区块链等技术领域结合开源，已经呈现出技术与产业协同发展的新局面。

### 3.2.1 开源与基础设施

#### 操作系统

当前国内基于Linux发行版而构建的操作系统层出不穷，加速了国产操作系统的发展，国内开发者对操作系统的关注度也日趋增长。由于自研操作系统的投入巨大且研发、维护、更新周期长，能形成一定生态规模的操作系统在全球局指可数，能够打破已有市场的新型操作系统更少。因此，多年来研发操作系统及通过自研操作系统盈利的国内企业极少。

近年来随着开源声势在国内日渐浩大，操作系统领域也在拥抱开源的情况下，诞生了一批国产开源操作系统，如华为主导的OpenEuler服务器领域操作系统和OpenHarmony移动终端/物联网操作系统，以及阿里巴巴主导的OpenAnolis服务器操作系统、腾讯主要的OpenCloudOS服务器操作系统。众多操作系统领域的利益相关方也形成了一种共识：开源有助于开放创新，源代码公开可供修改学习；开源还能帮助企业塑造品牌影响力。

目前的操作系统的边界已经被大大地扩展了。在产业界，操作系统在努力向国际先进水平靠近。如：

* 国内的 OpenEuler 操作系统、龙蜥操作系统、麒麟操作系统、统信操作系统等，与国外的 Ubuntu 操作系统、RedHat 操作系统、SUSE 操作系统类似，都是基于 Linux 操作系统内核的多种软件集合形成的 Linux 发行版；
* 运行在手机上的 OpenHarmony 操作系统与 Google 的 Android 操作系统类似，都是基于 Linux 操作系统内核，提供适合触摸交互的图形交互软件框架和移动终端共性服务的移动终端类操作系统；
* 运行在嵌入式设备上的 OpenHarmony 操作系统、RT-Thread、SylixOS 等则是属于实时操作系统（RTOS）范围，除了在传统工业控制上继续发展之外，还在互联网、物联网、分布式协同领域等快速突破，形成了开发环境、分布式协同等更广泛的系统级支持；
* 在目前火热的自动驾驶领域，不少国内新造车企业（如理想、蔚来、小鹏等），与国外的特斯拉等在多方位进行竞争，都开展了面向新型电子驾驶、自动驾驶的操作系统研发，形成了新的操作系统产业热点。


#### 芯片

相比价值已达数百亿美元的开源软件生态，芯片虽已成为支撑各行各业的基石，但开源芯片仍处于起步阶段。在处理器芯片领域，基于开源指令集 RISC-Ⅴ的开源芯片生态正在快速崛起，为开源芯片生态的创新降低了技术门槛，为包括中国在内的广大发展中国家突破中央处理器（CPU）芯片领域的技术壁垒和市场壁垒带来新机遇。虽然 RISC-Ⅴ 在中国发展得如火如荼，但基于 RISC-Ⅴ 构建开源芯片生态仍面临若干挑战，开源处理器（L2 级）仅仅是一个必要条件，还需要软件、应用、人才、资金等多种关键要素。中国作为制造业大国，仍需大量进口芯片，甚至面临“卡脖子”困境，面临极大的供应链风险。近期全球陆续出现的“缺芯潮”，导致汽车制造等重要工业领域停工停产，使包括中国在内的世界各国都蒙受了不可估量的经济损失。
 
#### 数据库

早在20世纪50年代，互联网技术（ARPANET）的先驱们就十分推崇同行评审和开放反馈，用户组通过共享源代码，相互扶持、激发创新，到20世纪90年代互联网诞生时，协作、开放、创新的价值观就已植根于互联网的内核之中。

在数据库技术领域，始于70年代的Ingres项目，代码就使用BSD许可证分发，在其基础之上，以各种形式演绎出包括 Sybase、Microsoft SQL Server、NonStop SQL、Informix 、PostgreSQL等著名产品，成为数据库历史上最成功的项目之一。

本质上，开源软件和闭源软件都只是一种软件研发和消费模式，在不同时期和场景有着各自独特的竞争力和优势体现。时至今日，开源软件依托其社区开发模式，能更快的实现产品迭代和用户触达，进而形成免费软件加付费服务的业务模式，并进一步通过云获得价值回报，MongoDB等数据库都在探索这一模式。此外，从市场竞争战略来看，软件开源已经成为后来者扩大其市场影响力、追赶头部企业的重要手段。

国内开源数据库的发展，经历了借鉴、发展、创新的全历程，早期国产数据库的探索者人大金仓就是以PostgreSQL为基础，而NewSQL的代表产品TiDB则是源自2013年Google Spanner/F1论文的技术实现，更多的NoSQL数据库也相继开源，如悦数科技在2019年开源了它的原生图数据库Nebula Graph的alpha版。自2019年以来，国内开源数据库领域快速发展，大事件频现，推动国内开源产业的蓬勃兴盛。

据 DB-Engines 的数据显示，自2021年1月，开源数据库的流行度首次超越商业数据库，并持续领先。全球 383 款数据库中，开源数据库占据 51.7%，排名前十的数据库中，开源数据库占据六席。据墨天轮的中国数据库流行度排行榜，198个数据库产品中包含13个开源的数据库产品，而榜单的前十名就有5个开源产品。从数据库开源项目的现状来看，全球最受欢迎的两种开源数据库MySQL 与 PostgreSQL是一系列数据库产品衍生的基础，中国数据库流行度排行榜中，源自MySQL和PostgreSQL的数据库数量分别为12和18。在今天的数据库领域，开源已经成为主要的趋势和潮流。

![](https://img-blog.csdnimg.cn/8a90a584727e4edba43e4df5555cd4e9.png)<br/>*DB-Engines 商业数据库和开源数据库流行度趋势对比*

|项目名称	|项目地址	|项目简介|
|-|-|-|
|TiDB	|https://github.com/pingcap/tidb	|TiDB是由PingCAP公司研发的分布式HTAP数据库产品，具备水平扩容或缩容、金融级高可用、实时 HTAP、云原生分布式、兼容 MySQL 5.7 协议和 MySQL 生态等重要特性。|
|Apache Doris	|https://github.com/apache/incubator-doris|	Apache Doris是百度研发的现代化MPP分析型数据库产品，可以支持10PB以上的超大数据集实时分析查询。|
|TDengine|	https://github.com/taosdata/TDengine	|TDengine是涛思数据推出的专为物联网、车联网、工业互联网、IT运维等设计和优化的大数据平台。|
|Nebula Graph	|https://github.com/vesoft-inc/nebula-graph	|Nebula Graph是悦数科技推出的分布式、易扩展的原生图数据库，能够承载千亿个点和万亿条边的超大规模数据集毫秒级查询。|
|StarRocks|	https://github.com/StarRocks/starrocks	|StarRocks是鼎石科技推出的新一代全场景MPP数据库，采用全面向量化技术，目标是成为新一代流批融合的极速湖仓（Lakehouse）。|
|openGauss	|https://github.com/opengauss-mirror/openGauss-server	|openGauss是一款由华为在2020年开源的关系型数据库管理系统，采用木兰宽松许可证v2发行，深度融合了华为在数据库领域的企业级经验，打造国内根社区。|
|PolarDB-for-PostgreSQL|	https://github.com/ApsaraDB/PolarDB-for-PostgreSQL	|PolarDB-for-PostgreSQL是阿里云自主研发的云原生数据库产品，100% 兼容PostgreSQL，采用基于 Shared-Storage的存储计算分离架构，具有极致弹性、毫、秒级延迟、HTAP能力。|
|OceanBase|	https://github.com/oceanbase/oceanbase|	OceanBase是由蚂蚁集团自主研发的高可用、高性能、横向扩展、兼容SQL标准的企业级分布式关系数据库。|
|TBase|	https://github.com/Tencent/TBase|	TBas是腾讯基于PostgreSQL研发的分布式HTAP数据库，适用于海量数据、高并发的数据处理场景。|
|gStore	|https://github.com/pkumod/gStore	|gStore是一种原生基于图数据模型(Native Graph Model)的RDF数据管理系统，由邹磊教授领导的北京大学王选计算机研究所数据管理实验室（PKUMOD）研发。|
|IoTDB|	https://github.com/apache/iotdb	|IoTDB是清华大学研发的一款聚焦工业物联网、高性能、轻量级的时序数据管理系统，2014年项目启动，2018年成为中国高校首个进入Apache孵化器的项目。|

*中国主导的开源数据库*


### 3.2.2 开源与人工智能
	 
据艾瑞咨询分析，2021年人工智能核心产业规模预计达到1998亿元规模，相应规模将于2026年超过6000亿元，2021-2026年的复合年均增长率为24.8%，人工智能产业正从发展期向成熟期过渡，除AI芯片外的细分技术赛道产业已跨过高速增长期，步入了稳步增长阶段。

在产业增长期，人工智能领域的企业与研究人员正通过结合开源，促使各环节提升经济生产活动效能。如今，在 AI 模型规模更加庞大、算法架构更为复杂、所需训练数据更为巨大和繁杂的情况下，开源可以一定程度上降低研发成本，提高研发效率。通过将已有研发成果汇集于开源代码库中，帮助更多开发者进行技术研发工作，已是人工智能领域的惯例。2022年，在推荐、强化学习、机器人等领域，更多人工智能代码库开源，形成了垂直、活跃的交流社区，助力产业发展。


从研究方向看，人工智能领域的研究人员热爱开源，且热衷于基础性的研究内容，如深度学习开源框架、目标检测开源框架等。此外，图像分类、语义理解、图像分割、文字识别、语音合成等实用性场景同样拥有极高的关注度。

从研究对象看，从早期的文本、图像、音频和视频，渐渐转向3D数据模态。带来的影响是针对数字人的研究得到了空前关注。基于3D的数字人、元宇宙等内容已然成为各大科技公司争相角逐的热点内容。

从产业角度看，人工智能开源项目从原本的小型应用场景（如目标检测、文字识别等），逐渐向大而全的生态系统转变。

从开源单位看，企业的研究院相比高校的实验室，产出了更多有影响力的项目，国内人工智能开源项目所属单位影响力较大的如百度、京东、阿里巴巴、腾讯、字节跳动、商汤、旷视等，可见各大企业近年来在不断加大开源社区生态建设方面的投入。

总体来看，国内在人工智能领域的研究日益广泛，相应的开源项目也层出不穷，许多有影响力的工作均得到了来自全球各地开发者的贡献。开源极大地促进了新技术的形成和新产业的落地。

![在这里插入图片描述](https://img-blog.csdnimg.cn/1339c2b81def46c2a1e818583615ae35.png#pic_center)<br/>*LF AI 和数据基础交互全景图（LF AI & Data Foundation Interactive Landscape）*

|项目名称|	项目地址	|项目简介|
|-|-|-|
|PaddlePaddle	|https://github.com/PaddlePaddle/Paddle	|飞桨(PaddlePaddle) 是由百度自主研发的功能完备的产业级深度学习平台，集深度学习核心框架、基础模型库、端到端开发套件、工具组件和服务平台于一体。飞桨源于产业实践，致力于与产业深入融合，提供了领先的深度学习&机器学习任务开发、训练、部署能力，加速企业从算法研发到产业落地的过程。|
|OpenMLDB	|https://github.com/4paradigm/OpenMLDB	|OpenMLDB是一个开源机器学习数据库，提供线上与线下一致的生产级特征平台，致力于解决AI工程化落地的数据治理难题，已在上百个企业级人工智能场景中得到落地。|
|MMCV|	https://github.com/open-mmlab/mmcv	|MMCV是一个面向计算机视觉的基础库，它支持了很多开源项目，如图像分类、目标检测、语义分割、姿态估计视频理解和图片视频生成等。|
|MegEngine	|https://github.com/MegEngine/MegEngine	|天元（MegEngine）是旷视自主研发的开源深度学习框架，能够帮助开发者高效地完成深度学习算法的设计、训练、部署，有效提升AI研发工作效率。|
|MNN	|https://github.com/alibaba/MNN	|MNN是一种高效轻量级的深度学习框架。它支持深度学习模型的推理和训练，在设备的推理和训练方面具有行业领先的性能。|
|ncnn	|https://github.com/Tencent/ncnn|	ncnn是一个为手机端极致优化的高性能神经网络前向计算框架。ncnn从设计之初便考虑手机端的部署和使用。无第三方依赖，可跨平台，手机端CPU的速度快于目前所有已知的开源框架。|
|BytePS|	https://github.com/bytedance/byteps|	BytePS是一个高性能的通用分布式训练框架。它支持TensorFlow、Keras、PyTorch和MXNet，并且可以在TCP或RDMA网络上运行。|
|ROMP	|https://github.com/Arthur151/ROMP	|ROMP是京东AI研究院开发的，业界第一个实现从图像端估计三维人体形状和姿态的单阶段算法。ROMP采用简洁的端到端设计，具有很强的可扩展性，同时支持实时估计，便于借此进一步探索多人场景下更丰富的感知和交互功能。|
|智能供应链开源工具	|https://git.openi.org.cn/JDOpenISCT|	智能供应链开源工具（Open Intelligent Supply Chain Toolbox）依托京东AIOC技术与供应链技术，整合京东内外数据，为各大企业、创业公司以及各级政府提供一站式全流程的智能供应链开源工具。|
|OpenMLDB|	https://github.com/4paradigm/OpenMLDB	|OpenMLDB是第四范式搭建的机器学习数据库，以开源的特征数据治理能力、SQL开发能力，提供全栈功能、低门槛特征数据计算和管理平台，面向闭环解决AI工程化落地的数据治理难题，帮助企业做到低成本、高效率地解决问题，已在上百个企业级人工智能场景中落地。|

*2022年国内人工智能领域典型开源项目*

### 3.2.3 开源与云计算
	
云计算如今已是IT业界的主流技术，越来越多的用户选择云计算平台作为自己软件业务的基础设施，而云计算业务带来的IT产业营收比重也越发凸显。云计算的概念从20世纪80年代发端，到真正成型落地并广为人知，开源理念和开源软件在其中起到了决定性的推动作用。

首先系统软件里，以Linux为代表的开源的操作系统是云计算软件技术栈里坚实的基础，还有开源的虚拟化技术对于计算资源的池化也是必不可少的一环，包括Xen，KVM，Qemu等开源项目。云计算技术需要管理的资源，除了计算资源之外，网络资源和存储资源也是缺一不可的，同样，在网络技术软件栈和存储技术软件栈里，各种逐渐成熟的开源技术和开放标准，也加速了云计算时代的到来。作为云计算产业的先锋Amazon AWS，不可否认就是架构在这一系列的开源软件之上的。在AWS稳定的技术表现和成功的商业模式的带动下，一系列开源的云计算基础架构管理软件风起云涌，而时至今日，OpenStack最终成为最为成功和唯一事实上的标准IaaS开放平台。

同时，在过去几年里，容器化和容器资源的管理，也逐渐走向成熟，并快速被广大开发人员和厂商所采用，也标志了云（计算）原生时代的到来。作为云原生领域最具权威的组织，云原生CNCF从2016年11月开始发布并持续更新[云原生全景图](https://landscape.cncf.io)（Cloud Native Landscape），帮助企业和开发人员快速了解云原生体系的全貌。图中左半部分按照层级从下至上分别是Kubernetes服务提供商、资源配置工具、运行时工具、编排与调度工具、应用开发工具，涵盖了全球云原生开源项目及其所属厂商。开源在云原生体系中起到了至关重要的作用，几乎所有的云原生技术，都有开源项目作为其代表实现或主流方案，从某种意义上整个云原生体系是构建在开源上的。

![在这里插入图片描述](https://img-blog.csdnimg.cn/826d67c2bb114cbaa44ba23faf383c15.png#pic_center)<br/>*CNCF云原生技术全景图*

近年来国内涌现出一批优秀且成熟的开源云原生项目，具有代表性的有PingCap推出的分布式事务键值数据库TiKV；阿里巴巴的云原生镜像分发系统Dragonfly、分布式内存数据管理引擎Vineyard；京东为大规模容器平台设计的分布式文件系统ChubaoFS；以及由南京大学 PASALab 副研究员顾荣博士、阿里云容器服务高级技术专家车漾、Alluxio 项目创始成员范斌博士联合推动发起的 Fluid；等等。

### 3.2.4 开源与隐私计算

隐私计算作为一项可以保障数据流通过程中“原始数据不出域、数据可用不可见”的技术，成为数据要素可信流通的关键技术模式。但各闭源平台间并不互通，促使“数据孤岛”变成“技术孤岛”。而相对于不同厂商间技术路线的各自为政，基于开源框架的互联互通将更有利于隐私计算产业生态的形成。也因此，开源隐私计算技术框架成为降低企业隐私计算技术研发成本，打破“技术孤岛”， 实现跨平台互联互通，推动数据要素流通重要且有效的途径。让技术在接受多维度检验的同时，建立起更加敏捷、全面的反应机制，推进技术迭代升级、平台互联互通与产业健康发展。
 
据中国信通院报告显示，近两年，国内外很多大厂和创业团队都在积极开源，从开源项目的活跃度和影响力来看，联邦学习的开源生态为工业化的落地应用贡献了强劲力量，特别是FATE，2020年及之后出现的很多联邦学习类产品都或多或少的吸收和借鉴了FATE供给的营养。在中国信通院调研统计中，55%的国内隐私计算产品是基于或参考开源项目开发的，这其中开源项目就以FATE为主。

### 3.2.5 开源与区块链

由于区块链技术去中心化、多方共享、可扩展等特点，使该领域绝大多数项目都是开源的，而开源也赋能区块链领域的技术创新，近几年尤为活跃。最受关注的方向便是以太坊的扩容问题，其中，基于零知识证明的ZK-Rollup方案被Vitalik Buterin寄予厚望。它的想法是，将交易的合法性验证的主要工作转移到主链之外，同时，通过零知识证明的方法保证主链级别的安全性。这一方法有望将以太坊的交易效率提高100倍左右。ZK-Rollup方案针对的是一些既定的交易类型，为了解决一般智能合约的类似问题，难度更大的ZK-EVM方案被提出，该方向目前已有若干团队进行研发。

| 项目名称	| 项目地址| 	项目简介| 
| --| -| -| 
| Chain33| 	https://github.com/33cn/chain33	| Chain33是由复杂美自主研发的区块链底层开发平台，是一套支持共识，数据库，执行器等可插拔且易升级的区块链架构。基于Chain33搭建的POS公链，以及多条平行链、多条私有链和联盟链都平稳运行，业务涉及游戏，金融，电商，健康等领域。| 
| 长安链·ChainMake	| https://git.chainmaker.org.cn/chainmaker| 	长安链是中国首个自主可控区块链软硬件技术体系，ChainMaker是其打造的区块链开源底层软件平台。包含区块链核心框架、丰富的组件库和工具集，致力于为用户高效、精准地解决差异化区块链实现需求，构建高性能、高可信、高安全的新型数字基础设施。| 
| FISCO BCOS| 	https://github.com/FISCO-BCOS/FISCO-BCOS	| FISCO BCOS是由金链盟开源工作组协作打造的安全可控的企业级金融联盟链底层平台，已有数百个应用项目基于FISCO BCOS底层平台研发，超80个已在生产环境中稳定运行。| 
| JD Chain	| https://github.com/blockchain-jd-com/jdchain	| JD Chain是京东专为企业应用设计的区块链框架系统，适用于多种通用业务场景，秉承简单易用、灵活高效的设计理念，满足企业积木化的按需定制，让企业快速进入区块链世界。| 
| XuperChain| 	https://github.com/xuperchain/xuperchain	| XuperChain是百度自主研发，拥有完全自主知识产权的区块链底层技术。拥有500余篇核心技术专利。XuperChain以高性能、自主可控、开源为主要设计目标，响应国家政策，打破了国外技术在区块链技术领域的垄断，致力于创建最快、最通用、最好用的区块链底层技术。| 

*国内广泛使用的区块链开源项目*


### 3.2.6 开源与工业互联网
 
全球工业互联网正处于产业格局未定的关键期和规模化扩张的窗口期，各个国家围绕核心标准、技术、平台等加速布局，我国工业互联网发展也在稳步推进。据CNNIC发布的《中国互联网络发展状况统计报告》，截至2021年12月，我国有全国影响力的工业互联网平台已超150个，接入设备总量超7600万台套，在建“5G+工业互联网”项目超2000个。

作为智能制造、工业互联网的核心内容，工业软件已渗透并应用到工业领域的几乎所有核心环节，而近年来工业软件与开源的结合有力冲击了原先关键技术的垄断，为我国实现弯道超车提供了可能。在研发设计类软件、生产控制类软件、业务管理类软件和工业数据软件中，均涌现出了大量开源软件。

研发设计类：以计算机辅助设计（CAD）为例，为打破如AutoCAD 等流行闭源软件的垄断，用于3D建模的FreeCAD、2D建模的LibreCAD等CAD开源软件出现。

生产控制类：以工业设备中常见的可编程逻辑控制器（PLC）为例，涌现出OpenPLC等PLC开源软件以及Apache PLC4X等PLC数据采集软件。

业务管理类：ERP、CRM类开源软件数量众多，如 Apache基金会旗下的Apache OFBiz项目。

工业数据软件：该类别软件离IT域最近，在开源方面的成果也最为丰富，如Eclipse基金会推出的数字孪生项目Eclipse Ditto以及Apache基金会的工业物联网数据库项目Apache IoTD。

随着开源已蔓延至工业互联网领域，我国工业软件的发展得到助力，如中望软件、中控技术、华大九天等国内企业分别推出中望CAD、DCS控制系统ECS-700X、EDA全流程工具等国产化软件。总体而言，开源加速了我国工业软件的成长速度，同时也有助于形成我国工业互联网发展新优势。

|类目|网址|
|-|-|
|计算机辅助仿真FastCAE|	https://github.com/DISOGitHub/FastCAE|
|开源电子设计自动化	|https://gitee.com/opendacs|
|制造执行系统MES|	https://gitee.com/wangziyangyang/MES-Springboot|
|监控采集系统RapidSCADA|	https://github.com/RapidScada/scada|
|监控采集系统SharpSCADA|	https://github.com/GavinYellow/SharpSCADA|
|供应链系统|	https://github.com/doublechaintech/scm-biz-suite|
|仓库管理系统WMS	|https://github.com/Singosgu/GreaterWMS|
|仓库管理系统jeewms|	https://gitee.com/erzhongxmu/jeewms|
|企业资源规划jshERP|	https://github.com/jishenghua/jshERP|
|工业协议边缘网关NEURON	|https://github.com/emqx/neuron|
|工业MQTT协议网关	|https://github.com/emqx/emqx|
|工业物联网数据库管理系统	|https://github.com/apache/iotdb|

*由国内开发者发起或主导的优秀工业软件列表*
